//
//  OPSymmetricKey.h
//  ApplicationFrameworks
//
//  AES-GCM Key based on OpenSSL
//
//  Created by Roustem Karimov on 2015-03-18.
//
//

#import <Foundation/Foundation.h>

@class B5PersonalKey;
@class OPJSONWebKey;
@class OPKeyPair;

@interface OPSymmetricKey : NSObject <NSSecureCoding>

@property (nonatomic, strong) NSString *kid;

+ (OPSymmetricKey *)generate;
+ (OPSymmetricKey *)decryptJSON:(NSDictionary *)ciphertext withSymKey:(OPSymmetricKey *)key error:(NSError **)error;
+ (OPSymmetricKey *)decryptJSON:(NSDictionary *)ciphertext withKeyPair:(OPKeyPair *)keyPair error:(NSError **)error;
+ (OPSymmetricKey *)symmetricKeyWithDecryptedJSON:(NSDictionary *)decryptedJSON;
+ (OPSymmetricKey *)symmetricKeyWithId:(NSString *)keyId algorithm:(NSString *)algorithm key:(NSData *)rawKeyData;

+ (OPSymmetricKey *)deriveUsingAlg:(NSString *)alg enc:(NSString *)enc iterations:(NSInteger)iterations salt:(NSData *)salt email:(NSString *)email password:(NSString *)password personalKey:(B5PersonalKey *)personalKey;

- (id)initWithJSON:(NSDictionary *)json;
- (instancetype)initWithKID:(NSString *)kid;

- (NSString *)alg;
- (NSDictionary *)exportAsJSON;

- (NSData *)rawEncrypt:(NSData *)plaintext nonce:(NSData *)nonce error:(NSError **)error;
- (NSData *)rawDecrypt:(NSData *)data nonce:(NSData *)nonce error:(NSError **)error;

- (NSDictionary *)encrypt:(NSData *)plaintext error:(NSError **)error;
- (NSData *)decrypt:(NSDictionary *)ciphertext error:(NSError **)error;

- (NSDictionary *)encryptedJSONWithSymKey:(OPSymmetricKey *)key error:(NSError **)error;

- (NSData *)HMACSHA256ForData:(NSData *)data;

- (BOOL)isEqualToSymmetricKey:(OPSymmetricKey *)otherSymmetricKey;

@end

@interface OPSymmetricKey (FileURL)
+ (NSData *)randomNonce;
- (BOOL)encryptFromFileURL:(NSURL *)sourceURL toURL:(NSURL*)destinationURL nonce:(NSData *)nonce error:(NSError **)error;
- (BOOL)decryptFromFileURL:(NSURL *)sourceURL toURL:(NSURL*)destinationURL nonce:(NSData *)nonce error:(NSError **)error;
@end